//===============================================================================================
// Object:			zViewer
//						zSearchRequest, zStaticPageRequest
//
// Description:	Manages the display of the page viewing area including the tracking
//						of history.
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

var kSearchingMsg  = 1;
var kRetrievingMsg = 2;
var kResultsPage = "dhtmlHelpResults.htm";
var kItemPage = "dhtmlHelpItem.htm";
var kStaticItemPage = "dhtmlHelpStaticItem.htm"

var kRegExFileNameNoExt = new RegExp();
kRegExFileNameNoExt.compile( "(.*)\\..*$" );
	// regular expression that matches filename without extension

var kRegExFileName = new RegExp();
kRegExFileName.compile( ".*\\/(.*)" );
	// regular expression that matches the filename, no path
	
var kRegExWordCount3 = new RegExp();
kRegExWordCount3.compile( "^(?:\\w+\\W+){3}" );
var kRegExWordCount5 = new RegExp();
kRegExWordCount5.compile( "^(?:\\w+\\W+){5}" );
	// regular expression that limits the word count


gAnswerWorks = null;			// AnswerWorks ActiveX object
gAwh = null;

gFormsets = null;				// Array of cached formset objects
gCurrentFormsets = null;	// Array of formsets to search
gIndexPaths = null;			// Paths of indexes to search

gSideNavigatorStates = new Array(
	"MoreInfo",
	"GeneralHelp",
	"TroubleShooting"
);


//-----------------------------------------------------------------------------------------------
// zRequestBase - base request object
//-----------------------------------------------------------------------------------------------
function zRequestBase() {}

//-----------------------------------------------------------------------------------------------
function _zRequestBaseSetPageInfo( doc )
	// Gather info from the current page displayed in the specified window
{
	if( !doc ) return;
	
	// Get the page title
	if( !this.title || this.title.length==0 ) this.title = doc.title;
	this.scrollPos = doc.documentElement.scrollTop; // IE 6
	if( 0 == this.scrollPos ) this.scrollPos = doc.body.scrollTop; // IE 5.5
}

//-----------------------------------------------------------------------------------------------
p = zRequestBase.prototype;

// Interface for all derived request objects
p.isSame = function( /*item*/) { return false; }
	// returns true if the specified item is the same as this item

p.isBackable = function(){ return (this.history) ? this.history.isBackable() : false; }
p.isForwardable = function(){ return (this.history) ? this.history.isForwardable() : false; }
	// If the item has a nested history, check if the nested items are backable or forwardable.	

p.setPageInfo = _zRequestBaseSetPageInfo;
	// Extract information from the page currently displayed in the viewer
	
p.getTypeFromIndex = function( indexFilename ) { return indexFilename.replace( kRegExFileNameNoExt, "$1" ).toLowerCase(); }
	// Extract the help type from the index filename

// p.navigate = function( /*wnd*/ ) {}
	// Display the results of this request in the viewer
	// Derivations must define

p.push = function( nestedItem ){ return (this.history) ? this.history.push( nestedItem ) : false; }
	// Add the specified item to the nested history for this item
	// Returns true if the item was added

p.back = function() { return (this.history) ? this.history.back() : null; }
p.forward = function() { return (this.history) ? this.history.forward() : null; }
	// Move the current position in the nested history back or forward.
	// Returns the item at the new current position

p.splice = function() { if( this.history ) this.history.splice(); }
	// Makes the current item in the nested history the last item in the history.
	// (i.e. forward navigation history is deleted)

// p.toString = function() { return ""; }
	// Self describe - derivations must define

p.history = null;
	// nested history

p.bDebug = false;
	// Show debug info
	
p.bPopupMode = false;
	// Help window is small popup
	
p.appMode="";
	// If true, help was started from an easy step state.

p.scrollPos = 0;
p.title = null;

p = null;


//-----------------------------------------------------------------------------------------------
// zSearchRequest - request object that encapsulates a search request and its accompanying
// results shown in the viewer.
//-----------------------------------------------------------------------------------------------
function zSearchRequest( query )
{
	if( query ) this.query = query;
	this.history = new zHistoryList();
}

//-----------------------------------------------------------------------------------------------
function _zSearchRequestGetStartingIndex()
{
	var cur = this.history.current();
	return ( cur ) ? cur : 0;
}

//-----------------------------------------------------------------------------------------------
function _zSearchRequestIsSame( request )
{
	if( !request ) return false;
	if( this.constructor != request.constructor ) return false;		
	if( this.query == request.query ) return true;
	
	return false; 
}

//-----------------------------------------------------------------------------------------------
function _zSearchRequestNavigate()
{
	if( !this.query || this.query.length == 0 )
	{
		if( this.onNoResults ) this.onNoResults();
		return;
	}

	if( gViewer.wnd.gSearchRequest == this )
	{
		// Showing results for the same search request
		gViewer.wnd.nextResults( this.history.current() );
		return;
	}
	
	gViewer.loadPage( kResultsPage );
		// Display searching message and reliquish control to the browser.
		// The page calls zSearchRequestOnLoad when it has finished loading.
}

//-----------------------------------------------------------------------------------------------
function zSearchRequestOnLoad()
	// Callback from the results page telling that the page is ready to show results
	// Not a member method
{
	try
	{
		// Get the current search request
		var req = gViewer.currentRequest();
		if( !req || req.constructor != zSearchRequest ) return;
			
		// Load in the AnswerWorks ActiveX object if not already loaded
		if( !gAnswerWorks )
		{
			gAnswerWorks = new ActiveXObject( "awApi4.AnswerWorks.1" )
			gAnswerWorks.SetLanguage(0);
		}
				
		// Set the current formset context...formsets to be searched
		gViewer.setCurrentFormsetContext();

		// Build a list of indexes to be used in the search
		var idx = gCurrentFormsets.buildSearchContext();
		if( gbDebug ) debugMsg( "Indexes to search: " + idx );
			
		// Open up the indexes for searching if different from the current set
		if( !gAwh || !gIndexPaths || idx != gIndexPaths )
		{
			if( gbDebug ) debugMsg( "Opening answer works help" );
	
			// Set the synonym file
			var synFn = gCurrentFormsets.getSynonymFilename();
			if( synFn ) gAnswerWorks.SetSynonymFile( synFn );

			// Set the indexes to be searched
			gIndexPaths = idx;
			gAwh = gAnswerWorks.OpenHtmlHelp( gIndexPaths );
		}
		
		// Search
		var results = ( gAwh ) ? gAwh.Query( req.query ) : null;
		if( !results || results.count <= 0 )
		{
			// No results found, notify client
			if( req.onNoResults ) req.onNoResults();
			return;
		}

		// Show the results
		gViewer.wnd.showResults( req, results );
		
		req.redisplay = true;
	}
	catch(e)
	{
		debugMsg( "zSearchRequestOnLoad: " + e, true );
		if( req.onNoResults ) req.onNoResults();
	}
}

//-----------------------------------------------------------------------------------------------
function _zSearchRequestGetDescription( indexFilename )
	// Returns the type description associated with the specified filename reported from
	// the search results
{
	if( !gCurrentFormsets ) return "";

	return gCurrentFormsets.getDescription( this.getTypeFromIndex( indexFilename ) );
}

//-----------------------------------------------------------------------------------------------
function _zSearchRequestToString()
{
	if( !this.query ) return "";
	
	var shrtQuery = this.query.match( kRegExWordCount3 );
	var s = ( shrtQuery ) ? shrtQuery[0] + "<nobr>...</nobr>" : this.query;

	return 'search results for: <i>' + s + '</i>';
}

//-----------------------------------------------------------------------------------------------
zSearchRequest.prototype = new zRequestBase();
	// derive from zRequestBase

p = zSearchRequest.prototype;
p.constructor=zSearchRequest;

// Request common
p.isSame = _zSearchRequestIsSame;
p.navigate = _zSearchRequestNavigate;
p.toString = _zSearchRequestToString;

// Search request only
p.getStartingIndex = _zSearchRequestGetStartingIndex;
p.getDescription = _zSearchRequestGetDescription;

p.query = null;
p.onNoResults = null;
p.resultsPerPage = 10;
p.summaryWordCnt = 25;
p.redisplay = false;

p = null;


//-----------------------------------------------------------------------------------------------
// zStaticPageRequest - request object that encapsulates a request to show a static page 
// in the viewer.
//-----------------------------------------------------------------------------------------------
function zStaticPageRequest( href, opt )
{
	if( href )
	{
		this.href = unescape( href );
		if( opt )
		{
			this.href += '?';
			this.href += unescape( opt );
		}
	}
}

//-----------------------------------------------------------------------------------------------
function _zStaticPageRequestIsSame( request )
{
	if( !request ) return false;
	if( this.constructor != request.constructor ) return false;
	if( this.href == request.href ) return true;

	return false; 
}

//-----------------------------------------------------------------------------------------------
function _zStaticPageRequestToString()
{
	if( !this.title ) return "";
	
	var shrtTitle = this.title.match( kRegExWordCount5 );
	var s = ( shrtTitle ) ? shrtTitle[0] + "<nobr>...</nobr>" : this.title;

	return '<i>' + s + '</i>';
}

//-----------------------------------------------------------------------------------------------
zStaticPageRequest.prototype = new zRequestBase();
	// derive from zRequestBase
	
p = zStaticPageRequest.prototype;
p.constructor=zStaticPageRequest;

// request common
p.isSame = _zStaticPageRequestIsSame;
p.toString = _zStaticPageRequestToString;
p.navigate = function( wnd ) 
{ 
	if( wnd && this.href ) 
	{
		wnd.location.href = this.href; 
		if (this.href == "dhtmlHelpVideoLibrary.htm")
		{
			if (gViewer._sideNav)
				gViewer._sideNav.pressVideoBtn()
		}
	}
}

p.href = null;
p = null;


//-----------------------------------------------------------------------------------------------
// zStaticItemRequest - a zStaticPageRequest extended to makes the page look like a help page
// (adds search box, side bar, adds to history, etc)
//-----------------------------------------------------------------------------------------------
function zStaticItemRequest( href )
{
	this.base( href );
}

//-----------------------------------------------------------------------------------------------
zStaticItemRequest.prototype = new zStaticPageRequest();
	// derive from zStaticPageRequest
	
p = zStaticItemRequest.prototype;
p.constructor=zStaticItemRequest;
p.base = zStaticPageRequest

// request common
p.navigate = function() {  if( this.href ) gViewer.loadPage( kStaticItemPage + '?' + this.href ); }

p.href = null;
p = null;


//-----------------------------------------------------------------------------------------------
// zHelpItemRequest - request object that encapsulates a request to show a help item,
// combined or uncombined.
//-----------------------------------------------------------------------------------------------
function zHelpItemRequest( indexFilename, filename, helpType, title, relatedQuery )
{
	if( !filename ) return;
	if( !indexFilename && !helpType ) return; // one must be specified
	
	this.title = title;
	this.relatedQuery = relatedQuery;	
	this.helpType = ( helpType ) ? helpType : this.getTypeFromIndex( indexFilename );
	
//alert( filename );
	
	// Set the current formset context...formsets to be searched
	gViewer.setCurrentFormsetContext();

	// Get more info from the associated bucket
	var bucket = gViewer.getCurrentFormsetContext().getBucket( this.helpType );
	if( !bucket ) return;

	this.filename = filename.replace( kRegExFileName, "$1" );
		// Get the filename only...strip path

	this.baseRef = bucket.baseRef;
		// Get the base path

	this.combined = bucket.combined;
	if( this.combined ) this.combinerHash = bucket.combinerHash;
	
	this.version = bucket.version;
}



//-----------------------------------------------------------------------------------------------
function _zHelpItemRequestIsSame( request )
{
	if( !request ) return false;
	if( this.constructor != request.constructor ) return false;
	if( this.filename == request.filename && this.helpType == request.helpType ) return true;

	return false; 
}

//-----------------------------------------------------------------------------------------------
function _zHelpItemRequestNavigate()
	// Gather info from the current page displayed in the specified window
{
	if( !this.filename || this.filename.length == 0 )
	{
		// Invoke fail callback if present
		if( this.onFail ) this.onFail();
	}
	
	if (gViewer._sideNav)
	{
		gViewer._sideNav.pressByContext( this.filename );
	}

	gViewer.loadPage( kItemPage );
		// Display loading message and reliquish control to the browser.
		// The page calls zHelpItemRequestOnLoad when it has finished loading.
}

//-----------------------------------------------------------------------------------------------
function zHelpItemRequestOnLoad()
	// Callback from the help item page telling that the page is ready to show the item.
	// Not a member method
{
	// Get the current help item request
	var req = gViewer.currentRequest();
	if( !req ||
		 ( req.constructor != zHelpItemRequest &&
			req.constructor != zFieldHelpItemRequest )) return;

	// Show the item
	gViewer.wnd.showItem( req );
}

//-----------------------------------------------------------------------------------------------
zHelpItemRequest.prototype = new zStaticPageRequest();
	// derive from zStaticPageRequest (derived from zRequestBase)

p = zHelpItemRequest.prototype;
p.constructor=zHelpItemRequest;

// request common
p.isSame = _zHelpItemRequestIsSame;
p.navigate = _zHelpItemRequestNavigate

p.version = "";
p.combined = false;
p.combinerHash = null;
p.helpType = null;
p.baseRef = "";
p.filename = null;
p.onFail = null; // Callback on fail
p.relatedQuery = null;

p = null;


//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//-----------------------------------------------------------------------------------------------
// zHelpFAQRequest - request object for FAQs
//-----------------------------------------------------------------------------------------------
// filename : is actually an array of hash id's for the FAQ
// helpType : is "faq"
function zHelpFAQRequest( contextArray, helpType, title, formId, fieldId )
{
	if( (!contextArray) && (!formId)) 
		return;
		
	if (formId)
	{
		this.formId = formId;
		if (fieldId) this.fieldId = fieldId;
	}
	
	this.title = title;
	this.helpType = helpType;
	
	// Set the current formset context...formsets to be searched
	gViewer.setCurrentFormsetContext();

	// Get more info from the associated bucket
	var bucket = gViewer.getCurrentFormsetContext().getBucket( this.helpType );
	if( !bucket ) return;
	
	if ( contextArray )
	{
		this.faqHashArray = new Array();
		for(index = 0; index< contextArray.length; index++)
		{
			this.faqHashArray.push( contextArray[index] );
		}
	}
	
	//this.filename = filename.replace( kRegExFileName, "$1" );
		// Get the filename only...strip path

	this.baseRef = bucket.baseRef;
		// Get the base path

	this.combined = bucket.combined;
	if( this.combined ) this.combinerHash = bucket.combinerHash;
	
	this.version = bucket.version;
	
	if (!formId) return;
	
	// =========================================================
	// Adding this to be able to search for tax help and gov help.
	var taxHelpContext = findContextTypeByName( kTaxHelp );
	
	if( taxHelpContext )
	{
		bucket = gViewer.getCurrentFormsetContext().getBucket( taxHelpContext.type );
		if( bucket )
		{
			this.baseRef = bucket.baseRef;
				// Get the base path

			this.combined = bucket.combined;
			if( this.combined )
			{
				this.combinerHashes = new Array();
				this.combinerHashes.push( bucket.combinerHash );
			}

			this.prefixes = new Array( taxHelpContext.prefix );
			
		}
	}

	// See if there is goverment instructions content for this formset
	var instrContext = findContextTypeByName( kGovHelp );
	if( instrContext )
	{
		bucket = gViewer.getCurrentFormsetContext().getBucket( instrContext.type );
		if( bucket )
		{
			if( !this.baseRef ) this.baseRef = bucket.baseRef;
				// Get the base path

			if( !this.prefixes ) this.prefixes = new Array();
			this.prefixes.push( instrContext.prefix );
			
			this.combined = bucket.combined;
			if( this.combined )
			{
				if( !this.combinerHashes ) this.combinerHashes = new Array();
				this.combinerHashes.push( bucket.combinerHash );
			}
		}
	}
	
}



//-----------------------------------------------------------------------------------------------
function _zHelpFAQRequestIsSame( request )
{
	if( !request ) return false;
	if( this.constructor != request.constructor ) return false;
	if( this.filename == request.filename && this.helpType == request.helpType ) return true;

	return false; 
}

//-----------------------------------------------------------------------------------------------
function _zHelpFAQRequestNavigate()
	// Gather info from the current page displayed in the specified window
{
	if( (!this.faqHashArray) && (!this.formId) )
	{
		// Invoke fail callback if present
		if( this.onFail ) this.onFail();
	}
	
	if (gViewer._sideNav)
		gViewer._sideNav.pressMoreInfoBtn();
	gViewer.loadPage( "FAQs.htm" );
		// Display loading message and reliquish control to the browser.
		// The page calls zHelpItemRequestOnLoad when it has finished loading.
}

//-----------------------------------------------------------------------------------------------
function zHelpFAQRequestOnLoad()
	// Callback from the help item page telling that the page is ready to show the item.
	// Not a member method
{
	// Get the current help item request
	var req = gViewer.currentRequest();
	if( !req || req.constructor != zHelpFAQRequest ) 
		return;

	// Show the item
	gViewer.wnd.showItem( req );
}

//-----------------------------------------------------------------------------------------------
zHelpFAQRequest.prototype = new zStaticPageRequest();
	// derive from zStaticPageRequest (derived from zRequestBase)

p = zHelpFAQRequest.prototype;
p.constructor=zHelpFAQRequest;

// request common
p.isSame = _zHelpFAQRequestIsSame;
p.navigate = _zHelpFAQRequestNavigate

p.version = "";
p.combined = false;
p.combinerHash = null;
p.helpType = null;
p.baseRef = "";
p.faqHashArray = null;
p.onFail = null; // Callback on fail
p.relatedQuery = null;
p.formId = null;
p.fieldId = null;

p = null;
// END zHelpFAQRequest
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//-----------------------------------------------------------------------------------------------
// zFeedbackRequest - request object for feedback
//-----------------------------------------------------------------------------------------------
function zFeedbackRequest( installedStates, searchString )
{
	this.comment = "";
	this.problemType = "";
	this.topic = "";
	this.subtopic = "";
	this.contactName = "";
	this.contactPhone = "";
	this.contactEMail = "";
	this.installedStates = (installedStates) ? installedStates : null;
	this.searchString = (searchString) ? searchString : "";

	this.submit = _zFeedbackRequestSubmit;
	this.techSupport = function(){ goTechSupport() };
}

//-----------------------------------------------------------------------------------------------
function _zFeedbackRequestIsSame( request )
{
	if( !request ) return false;
	if( this.constructor != request.constructor ) return false;
	return true;
}
function zFeedbackRequestOnLoad()
	// Callback from the help item page telling that the page is ready to show the item.
	// Not a member method
{
	// Get the current help item request
	var req = gViewer.currentRequest();
	if( !req || ( req.constructor != zFeedbackRequest )) 
	{
		return ( null );
	}
	return( req );
}
//-----------------------------------------------------------------------------------------------
function _zFeedbackRequestNavigate()
	// Gather info from the current page displayed in the specified window
{	
	gViewer.loadPage( "dhtmlHelpFeedback.htm" );
}

function _zFeedbackRequestSubmit()
// Submit the feedback to the server via the C++ handler
{
	// Populate the dataexchange datasrc
	setDataSrcItem( "feedbackComment", this.comment );
	setDataSrcItem( "feedbackProblemType", this.problemType );
	setDataSrcItem( "feedbackTopic", this.topic );
	setDataSrcItem( "feedbackSubtopic", this.subtopic );
	// Contact information
	setDataSrcItem( "feedbackName", this.contactName );
	setDataSrcItem( "feedbackPhoneNumber", this.contactPhone );
	setDataSrcItem( "feedbackEMail", this.contactEMail );
	
	// Set these to empty because this is a request for feedback 
	// on the application not Help.  We may use it from the Where Do I Enter part.
	setDataSrcItem( "feedbackLastSearchStr", this.searchString );
	setDataSrcItem( "feedbackHelpType", "" );
	setDataSrcItem( "feedbackHelpScreenId", "" );
		
	onCmd( "submitFeedback" );
		// noncritical - ignore any failures
		
	return getLastCmdResult();		
}

//-----------------------------------------------------------------------------------------------
zFeedbackRequest.prototype = new zStaticPageRequest();
	// derive from zStaticPageRequest (derived from zRequestBase)

p = zFeedbackRequest.prototype;
p.constructor=zFeedbackRequest;

// request common
p.isSame = _zFeedbackRequestIsSame;
p.navigate = _zFeedbackRequestNavigate

p.comment = "";
p.problemType = "";
p.topic = "";
p.subtopic = "";
p.contactName = "";
p.contactPhone = "";
p.contactEMail = "";
p.searchString = "";
p.installedStates = null;

p.submit = _zFeedbackRequestSubmit;
p.techSupport = function(){ goTechSupport() };

p.onFail = null; // Callback on fail

p = null;
// END zHelpFAQRequest
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

//-----------------------------------------------------------------------------------------------
// zFieldHelpItemRequest - request object that encapsulates a request to show a help item
// combined or uncombined associated with a form and field id.
//-----------------------------------------------------------------------------------------------
function zFieldHelpItemRequest( formId, fieldId, bGovOnly )
{
	if( !formId ) return;

	this.formId = formId;
	if( fieldId ) this.fieldId = fieldId;

	// Assume if one type of formset specific help (non-app) is combined, they are all combined.
	// The base path will also be the same.  Use taxhelp as the reference bucket.
	// Get more info from the associated bucket
	var taxHelpContext = findContextTypeByName( kTaxHelp );
	if( !taxHelpContext ) return;

	// Set the current formset context...formsets to be searched
	gViewer.setCurrentFormsetContext();

	var bucket = null;
	
	if( !bGovOnly )
	{
		bucket = gViewer.getCurrentFormsetContext().getBucket( taxHelpContext.type );
		if( bucket )
		{
			this.baseRef = bucket.baseRef;
				// Get the base path

			this.combined = bucket.combined;
			if( this.combined )
			{
				this.combinerHashes = new Array();
				this.combinerHashes.push( bucket.combinerHash );
			}

			this.prefixes = new Array( taxHelpContext.prefix );
		}
	}

	// See if there is goverment instructions content for this formset
	var instrContext = findContextTypeByName( kGovHelp );
	if( instrContext )
	{
		bucket = gViewer.getCurrentFormsetContext().getBucket( instrContext.type );
		if( bucket )
		{
			if( !this.baseRef ) this.baseRef = bucket.baseRef;
				// Get the base path

			if( !this.prefixes ) this.prefixes = new Array();
			this.prefixes.push( instrContext.prefix );

			this.combined = bucket.combined;
			if( this.combined )
			{
				if( !this.combinerHashes ) this.combinerHashes = new Array();
				this.combinerHashes.push( bucket.combinerHash );
			}
		}
	}
}

//-----------------------------------------------------------------------------------------------
function _zFieldHelpItemRequestIsSame( request )
{
	if( !request ) return false;
	if( this.constructor != request.constructor ) return false;		
	if( this.formId == request.formId && this.fieldId == request.fieldId ) return true;

	return false; 
}

//-----------------------------------------------------------------------------------------------
function _zFieldHelpItemRequestNavigate()
	// Gather info from the current page displayed in the specified window
{
	if( !this.formId || this.formId.length == 0 )
	{
		// Invoke fail callback if present
		if( this.onFail ) this.onFail();
	}

	gViewer.loadPage( kItemPage );
		// Display loading message and reliquish control to the browser.
		// The page calls zHelpItemRequestOnLoad when it has finished loading.
}

//-----------------------------------------------------------------------------------------------
zFieldHelpItemRequest.prototype = new zStaticPageRequest();
	// derive from zStaticPageRequest (derived from zRequestBase)

p = zFieldHelpItemRequest.prototype;
p.constructor=zFieldHelpItemRequest;

// request common
p.isSame = _zFieldHelpItemRequestIsSame;
p.navigate = _zFieldHelpItemRequestNavigate;

p.formId = null;
p.fieldId = null;
p.combined = false;
p.combinerHashes = null;
p.baseRef = "";
p.onFail = null; // Callback on fail

p = null;


//-----------------------------------------------------------------------------------------------
// Encapsulates the history list - a list of request objects
//-----------------------------------------------------------------------------------------------
function zHistoryList()
{
	this.clear();
}

//-----------------------------------------------------------------------------------------------
function _zHistoryListClear()
{
	this._curPos = -1;
	this._items = new Array();
}

//-----------------------------------------------------------------------------------------------
function _zHistoryListCurrent()
{
	return ( this._curPos < 0 ) ? null : this._items[ this._curPos ];
}

//-----------------------------------------------------------------------------------------------
function _zHistoryListPrevious()
	// Return the previous item in the list
{
	if( !this.isBackable() ) return;

	var curItem = this.current();
	if( curItem && isNaN( curItem ) && curItem.isBackable && curItem.isBackable() )
	{
		return curItem;
	}

	var pos = this._curPos;
	pos--;

	return ( pos < 0 ) ? null : this._items[ pos ];
}

//-----------------------------------------------------------------------------------------------
function _zHistoryListIsBackable()
{
	// Are there previous items in the history list
	var bBackable = ( this._curPos > 0 );

	// Check if the current item has nested items and is backable
	if( !bBackable )
	{
		var curItem = this.current();
		if( curItem && isNaN( curItem ) && curItem.isBackable ) bBackable = curItem.isBackable();
	}

	return bBackable;
}

//-----------------------------------------------------------------------------------------------
function _zHistoryListIsForwardable()
{
	if( this._curPos < 0 ) return false;
	var bForwardable = ( this._curPos < (this._items.length-1) );

	if( !bForwardable )
	{
		var curItem = this.current();
		if( curItem && isNaN( curItem ) && curItem.isForwardable ) bForwardable = curItem.isForwardable();		
	}

	return bForwardable;
}

//-----------------------------------------------------------------------------------------------
function _zHistoryListPush( item )
{
	var curItem = this.current();	
	if( null != curItem )
	{
		if( isNaN( curItem ) )
		{
			if( curItem.isSame && curItem.isSame( item ) ) return false;
			if( curItem.splice ) curItem.splice(); // splice any nested items
		}
		else if( curItem == item ) return false;
	}

	// Clear the forward history from this position onward
	this.splice();

	// Add the new item
	++this._curPos;
	this._items.push( item );

	return true;
}

//-----------------------------------------------------------------------------------------------
function _zHistoryListSplice()
	// Makes the current position the last item in the history
	// (i.e. forward navigation history is deleted)
{
	var pos = this._curPos + 1;

	if( this.isForwardable() ) this._items.splice( pos, this._items.length - pos );
		// Clear the forward history from this position onward
}

//-----------------------------------------------------------------------------------------------
function _zHistoryListBack()
{
	if( !this.isBackable() ) return null;
	
	var curItem = this.current();	
	if( curItem && isNaN( curItem ) && curItem.isBackable && curItem.isBackable() )
	{
		// check if the item nested items
		curItem.back()
		return curItem;
	}

	--this._curPos;
	return this._items[ this._curPos ];
}

//-----------------------------------------------------------------------------------------------
function _zHistoryListForward()
{
	if( !this.isForwardable() ) return null;
	
	var curItem = this.current();	
	if( curItem && isNaN( curItem ) && curItem.isForwardable && curItem.isForwardable() )
	{
		// check if the item nested items
		curItem.forward()
		return curItem;
	}

	if( this._curPos >= (this._items.length-1) ) return null;

	++this._curPos;
	return this._items[ this._curPos ];
}

//-----------------------------------------------------------------------------------------------
function _zHistoryGetLastSearchQuery()
{
	var query = null;

	// back items
	for( var i = this._curPos; i >= 0; --i )
	{
		if( this._items[i].query )
		{
			query = this._items[i].query;
			break;
		}
	}

	// forward items
	if( !query )
	{
		var cnt = this._items.length;

		for( i = this._curPos+1; i < cnt; ++i )
		{
			if( this._items[i].query )
			{
				query = this._items[i].query;
				break;
			}
		}
	}

	return query;
}

//-----------------------------------------------------------------------------------------------
function _zHistoryGetLastFAQs()
{
	var req = null;

	// back items
	for( var i = this._curPos; i >= 0; --i )
	{
		if( this._items[i].constructor == zHelpFAQRequest )
		{
			req = this._items[i];
			break;
		}
	}

	// forward items
	if( !req )
	{
		var cnt = this._items.length;

		for( i = this._curPos+1; i < cnt; ++i )
		{
			if( this._items[i].constructor == zHelpFAQRequest )
			{
				req = this._items[i];
				break;
			}
		}
	}

	return req;
}

//-----------------------------------------------------------------------------------------------
p = zHistoryList.prototype;
p.current = _zHistoryListCurrent;
p.previous = _zHistoryListPrevious;
p.isBackable = _zHistoryListIsBackable;
p.isForwardable = _zHistoryListIsForwardable;
p.push = _zHistoryListPush;
p.back = _zHistoryListBack;
p.forward = _zHistoryListForward;
p.splice = _zHistoryListSplice;
p.clear = _zHistoryListClear;

p.getLastSearchQuery = _zHistoryGetLastSearchQuery;
p.getLastFAQs = _zHistoryGetLastFAQs;

p = null;


//-----------------------------------------------------------------------------------------------
// Encapsulates the management of the page viewing area including its history list.
//-----------------------------------------------------------------------------------------------
function zViewer( wnd, navBar, sideNav )
{
	this.wnd = wnd;
	this._navBar = ( navBar ) ? navBar : null;
	this._sideNav = ( sideNav ) ? sideNav : null;
	this.history = new zHistoryList();
}

//-----------------------------------------------------------------------------------------------
function _zViewerSetCurrentFormsetContext()
	// Initialize the current formset context
{
	// Create the formset cache if not yet created
	if( !gFormsets ) gFormsets = new zFormsetList();

	// Create the list of formsets to be used in the search
	gCurrentFormsets = null;
	gCurrentFormsets = new zFormsetList();
	gCurrentFormsets.buildContext( gFormsets );
}

//-----------------------------------------------------------------------------------------------
function _zViewerGetCurrentFormsetContext()
	// Get the current formset context, if one is not available, create one
{
	if( !gCurrentFormsets ) this.setCurrentFormsetContext();
	return gCurrentFormsets;
}

//-----------------------------------------------------------------------------------------------
function _zViewerUpdateNav()
	// Update the back and forward buttons to reflect the history state
{
	// Enable or disable the navigation buttons
	( this.history.isBackable() ) ? this._navBar.enableBackBtn() : this._navBar.disableBackBtn();
	( this.history.isForwardable() ) ? this._navBar.enableForwardBtn() : this._navBar.disableForwardBtn();
}

//-----------------------------------------------------------------------------------------------
function _zViewerNavigate( request )
{
	if( !request ) return false;
	
	// Gather some information about the current page before navigating away from it
	var cur = this.history.current();
	if( cur ) cur.setPageInfo( this.wnd.document );

	// append the request to the history
	this.history.push( request );

	// Enable or disable the navigation buttons
	if (this._navBar)
		this.updateNav();
	
	// Enable all side navigation buttons at this point.
	if (this._sideNav)
		this._sideNav.enableAllButtons();

	// Process the request
	request.navigate( this.wnd );
}

//-----------------------------------------------------------------------------------------------
function _zViewerGoBack()
{
	var req = this.history.back();
	if( req )
	{
		// Enable all side navigation buttons at this point.
		if (this._sideNav)
			this._sideNav.enableAllButtons();
		if (this._navBar)
			this.updateNav();
		req.navigate( this.wnd );
	}
}

//-----------------------------------------------------------------------------------------------
function _zViewerGoForward()
{
	var req = this.history.forward();
	if( req )
	{
		// Enable all side navigation buttons at this point.
		if (this._sideNav)
			this._sideNav.enableAllButtons();
		if (this._navBar)
			this.updateNav();
		req.navigate( this.wnd );
	}
}

//-----------------------------------------------------------------------------------------------
function _zViewerLoadPage( src ) { if(src) this.wnd.location.href = src; }
	// Show a page that is not added into the history

//-----------------------------------------------------------------------------------------------
p = zViewer.prototype;
p.currentRequest = function() { return this.history.current(); }
p.previousRequest = function() { return this.history.previous(); }
p.clearHistory = function() { return this.history.clear(); }
p.loadPage = _zViewerLoadPage;
p.updateNav = _zViewerUpdateNav;
p.navigate = _zViewerNavigate;
p.goBack = _zViewerGoBack;
p.goForward = _zViewerGoForward;

// formset context related
p.setCurrentFormsetContext = _zViewerSetCurrentFormsetContext;
p.getCurrentFormsetContext = _zViewerGetCurrentFormsetContext;

// informational
p.getLastSearchQuery = function() { return this.history.getLastSearchQuery(); }
p.getLastFAQs = function() { return this.history.getLastFAQs(); }

p = null;
